/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.access.zGlue.UserProfilesPluginImpl;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccDataBean;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.common.util.PIUserUtils;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.StringVector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class PIHMCUserList {
    private static final String[] m_validOpts = new String[]{HMCCommandUtils.FORMAT_PARAM, "--filter", "--header", "--script"};
    private static final String[] m_validFormats = new String[]{"name", "taskrole", "description", "resources", "resourcerole"};
    public AcaClient m_acaCl = null;
    private String m_delimiter = ",";
    private boolean m_header = false;
    private boolean m_format = false;
    private boolean m_script = false;
    private String m_filter = null;
    private Vector[] m_filterVt = null;
    private String[] m_filterNames = null;
    private boolean m_filterName = false;
    private Vector m_userVt = null;
    private boolean m_filterRole = false;
    private Vector m_roleVt = null;
    private boolean m_filterGrp = false;
    private Vector m_grpVt = null;
    private boolean m_filterRsrc = false;
    private Vector m_rsrcVt = null;
    private String[] m_actualKeys = m_validFormats;

    public int performCommand() throws PIHscClientException {
        Hashtable hashtable = new Hashtable();
        Vector<AccDataBean> vector = new Vector<AccDataBean>();
        StringVector stringVector = PIUserUtils.getUserList();
        if (stringVector == null) {
            AccUtils.throwCmdLineSyntaxError("", "USER_GETTING_PROPERTY_ERROR");
        }
        String string = "";
        String[] stringArray = null;
        Enumeration enumeration = stringVector.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), ":");
            String string2 = stringTokenizer.nextToken();
            if (this.m_filterName && !this.m_userVt.contains(string2) || stringTokenizer == null) continue;
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            if ((stringArray = this.m_acaCl.GetRoles(string2)) == null) {
                stringArray = new String[]{"Undefined"};
            }
            if (this.m_filterRole && !this.m_roleVt.contains(stringArray[0])) continue;
            String[] stringArray2 = this.m_acaCl.GetUserAssignment(string2, 2);
            if (stringArray2 != null && stringArray2.length > 0) {
                String[] stringArray3 = new String[stringArray2.length];
                n = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].equals(string2 + "_MRES")) continue;
                    stringArray3[n++] = stringArray2[i];
                }
                stringArray2 = stringArray3;
            }
            if (this.m_filterGrp) {
                bl = false;
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!this.m_grpVt.contains(stringArray2[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            bl = false;
            String string3 = null;
            String[] stringArray4 = null;
            String[] stringArray5 = this.m_acaCl.GetUserAssignment(string2, 4);
            if (stringArray5 != null) {
                bl = false;
                stringArray4 = new String[stringArray5.length];
                for (int i = 0; i < stringArray5.length; ++i) {
                    String string4;
                    String string5 = stringArray5[i];
                    if (string5.indexOf(AcaUtils.ALL_PARTITIONS_TAG) >= 0) {
                        String string6 = PIHmcAccessUtils.createCECInstIDFromAllPartID(string5);
                        string4 = PIHmcAccessUtils.getUserDefinedName(string6);
                        string3 = PIHmcAccessUtils.createAllPartitionUserDefName(string4);
                    } else if (string5.equals("ALL:")) {
                        string3 = UserProfilesPluginImpl.S_ALL_RESOURCES;
                    }
                    if (string3 == null) {
                        string3 = HSCResourceBundleUtil.getMessage("UserBundle", "UNAVAIL_RESOURCE", "");
                        AccUtils.DBG("No userDefName for =" + string5);
                    }
                    if (this.m_filterRsrc) {
                        for (int j = 0; j < this.m_rsrcVt.size(); ++j) {
                            string4 = (String)this.m_rsrcVt.get(j);
                            if (!string3.startsWith(string4)) continue;
                            bl = true;
                            break;
                        }
                    }
                    stringArray4[i] = this.m_script ? stringArray5[i] : "<ResourceID = " + stringArray5[i] + ">" + "<UserDefinedName = " + string3 + ">";
                }
            }
            if (this.m_filterRsrc && (!bl || stringArray5 == null || stringArray5.length <= 0)) continue;
            AccUtils.DBG("user Name=" + string2);
            AccUtils.DBG("user Descrip=" + string);
            AccUtils.DBG("user Role =" + stringArray[0]);
            AccUtils.DBG("user Group=" + stringArray2);
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            if (stringArray4 == null) {
                stringArray4 = new String[]{};
            }
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("name", string2);
            hashtable2.put("taskrole", stringArray);
            hashtable2.put("resourcerole", stringArray2);
            hashtable2.put("description", string);
            hashtable2.put("resource", stringArray4);
            AccDataBean accDataBean = new AccDataBean();
            accDataBean.setUserDataTable(hashtable2);
            vector.add(accDataBean);
        }
        PICmdOutputUtils.printResults(vector.elements(), this.m_actualKeys, this.m_delimiter, this.m_header, !this.m_format);
        if (vector.size() <= 0) {
            return 1;
        }
        return 0;
    }

    private void parseFilter(String string) throws PIHscClientException {
        AccUtils.DBG("In parseFilter " + string);
        CSVRecord cSVRecord = new CSVRecord(string, true, ",");
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            int n;
            String[] stringArray;
            String string2 = (String)iterator.next();
            int n2 = string2.indexOf("=");
            if (n2 == -1) {
                AccUtils.throwCmdLineSyntaxError("", "INVALID_FILTER");
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            AccUtils.DBG("Name=" + string3 + " Values=" + string4);
            if (string3.length() == 0 || string4.length() == 0) {
                AccUtils.throwCmdLineSyntaxError("", "INVALID_FILTER");
            }
            if ("names".equals(string3)) {
                stringArray = PIHMCCommandUtils.parseList(string4, ",");
                this.m_userVt = new Vector();
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        this.m_userVt.add(stringArray[n]);
                    }
                    this.m_filterName = true;
                }
                AccUtils.DBG(" user list=" + this.m_userVt.toString());
                continue;
            }
            if ("taskroles".equals(string3)) {
                stringArray = PIHMCCommandUtils.parseList(string4, ",");
                this.m_roleVt = new Vector();
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    this.m_roleVt.add(stringArray[n]);
                }
                this.m_filterRole = true;
                continue;
            }
            if ("resourceroles".equals(string3)) {
                stringArray = PIHMCCommandUtils.parseList(string4, ",");
                this.m_grpVt = new Vector();
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    this.m_grpVt.add(stringArray[n]);
                }
                this.m_filterGrp = true;
                continue;
            }
            if ("resources".equals(string3)) {
                stringArray = PIHMCCommandUtils.parseList(string4, ",");
                this.m_rsrcVt = new Vector();
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    this.m_rsrcVt.add(stringArray[n]);
                }
                this.m_filterRsrc = true;
                continue;
            }
            AccUtils.throwCmdLineSyntaxError(string3, "INVALID_FILTER_NAME");
        }
        AccUtils.DBG("Out parseFilter " + string);
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException, RequiredParameterException {
        String string = null;
        String string2 = null;
        String string3 = AccUtils.validateCmdOptions(m_validOpts, hashMap);
        if (string3 != null && string3.length() > 0) {
            AccUtils.throwCmdLineSyntaxError(string3, "INVALID_PARM");
        }
        string = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        this.m_filter = (String)hashMap.get("--filter");
        string2 = (String)hashMap.get("--header");
        this.m_header = string2 != null;
        this.m_script = hashMap.containsKey("--script");
        if (this.m_filter != null) {
            this.parseFilter(this.m_filter);
        }
        if (string != null && string.length() > 0) {
            this.m_format = true;
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(string, m_validFormats, m_validFormats.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            this.m_actualKeys = PICmdOutputUtils.checkKeys(m_validFormats, string, this.m_delimiter);
        }
    }

    public void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "HMCUSER_LIST_HELP"));
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        PIHMCUserList pIHMCUserList = new PIHMCUserList();
        try {
            String string2 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                arrayList.add(string2);
                if (!string2.equals(HMCCommandUtils.HELP_PARAM)) continue;
                bl = true;
                break;
            }
            if (bl) {
                pIHMCUserList.printHelp();
            } else {
                if (arrayList.size() > 0) {
                    HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                    pIHMCUserList.mapParameters(hashMap);
                }
                pIHMCUserList.m_acaCl = new AcaClient(1);
                n = pIHMCUserList.performCommand();
            }
            System.exit(n);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            string = requiredParameterException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            string = pIHscClientException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
    }
}

